// Blow Particles.js
//
//
// this is Particle script. place this .js file into ~/Library/Application Support/Cheetah3D/scripts/Particle folder.
//

var RAD = 180/Math.PI;

function buildUI( obj ) {
    
    obj.setParameter("name", "Blow Particles");
    
    obj.addParameterLink("target particle", true);
    
    obj.addParameterSeparator("blow core");
    obj.addParameterLink("blow core", true);
    obj.addParameterSelector("blow area", ["core radius", "core object radius", "infinite"], true, true);
    obj.addParameterFloat("core radius", 0.1, 0, 10000, true, true);
    obj.addParameterFloat("core power", 0.1, -10000, 10000, true, true);
    obj.addParameterFloat("core power var.", 0, -10000, 10000, true, true);
    obj.addParameterSelector("blow curve", [ "1/distance", "1/distance^2", "distance" ], true, true );
    obj.addParameterBool("alignment particle", 1, 0, 1, true, true);
    obj.addParameterFloat("delay", 0, -10000, 10000, true, true);
}

function buildObject( obj ) {
    
    var target = obj.getParameter("target particle");
    var blowCore = obj.getParameter("blow core");
    
    if (!target || target.family() != PARTICLEFAMILY) return;
    if (!blowCore) return;
    
    var targetMat = target.obj2WorldMatrix();
    var coreMat = blowCore.obj2WorldMatrix();
    
    var i;
    var area = obj.getParameter("blow area");
    var radius;
    if (area == 1 && blowCore.type() == BALL) {
        radius = blowCore.getParameter("radius");
    } else {
        radius = obj.getParameter("core radius");
    }
    var delay = obj.getParameter("delay");
    var power = obj.getParameter("core power");
    var power_var = obj.getParameter("core power var.");
    var corePos = coreMat.multiply( new Vec3D() );
    var curve = obj.getParameter("blow curve");
    var alignment = obj.getParameter("alignment particle");
    
    switch(curve) {
        case 0:
            var curveFunc = function() { return arguments[0] / ( arguments[1] ) };
            break;
        case 1:
            var curveFunc = function() { return arguments[0] / ( Math.pow( arguments[1], 2 ) ) };
            break;
        case 2:
            var curveFunc = function() { return arguments[0] * arguments[1] };
            break;
    }
    var core = obj.core();
    var targetCore = target.core();
    var count = targetCore.particleCount();
    
    
    // remove old particles.
    core.removeAllParticles();
    
    // copy particles.
    for (i = 0;i < count;i++) {
        
        var p = core.addParticle();
        var base_p = targetCore.particleAtIndex( i );
        
        var pos = targetMat.multiply( base_p.getPosition() );
        
        var dir = pos.sub( corePos );
        var distance = Math.sqrt( dir.x*dir.x + dir.y*dir.y + dir.z*dir.z );
        var vec = dir.multiply( 1 / dir.norm() );
        var rnd = base_p.getRand();
        
        distance += delay * rnd.y;
        if (area == 2 || distance < radius) {
            var d = curveFunc( power + (rnd.x * power_var), distance );
            pos = pos.add( vec.multiply( d ) );
        }
        p.setPosition( pos );
        p.setScale( base_p.getScale() );
        if (alignment) {
            var theta = Math.acos(vec.y)*RAD;
            var phi = Math.atan2(vec.x, vec.z)*RAD;
            p.setRotation( new Vec3D( theta, phi, 0 ) );
        } else {
            p.setRotation( base_p.getRotation() );
        }
        //print( i + ':' + descVec(p.getPosition()) );
    }
    
}

function descVec( vec ) {
    return ( vec.x.toFixed(3) + ', ' + vec.y.toFixed(3) + ', ' + vec.z.toFixed(3) );
}